import torch as t
from sklearn.metrics import roc_auc_score, balanced_accuracy_score, accuracy_score
import numpy as np
import pandas as pd
from pathlib import Path
from sklearn.metrics import recall_score


def calculate_threshold(scores: float, fpr=0.01):
    """Calculate threshold for a given false positive rate.""" 
    print("calculate threshold")
    threshold = t.quantile(scores, 1-fpr)
    return threshold

def calculate_recall_at_fpr(dishonesty_scores, dishonesty_labels, threshold):
    # 1-->dishonest, 0-->honest
    predictions = dishonesty_scores >= threshold 
    recall = recall_score(dishonesty_labels.float().cpu().numpy(), predictions.float().cpu().numpy())
    return recall

def calculate_auroc(scores, labels):
    """Calculate metrics for a probe on given predictions and labels."""
    labels = labels.detach().cpu().float().numpy() 
    scores = scores.detach().cpu().float().numpy()

    auroc = roc_auc_score(labels, scores)

    return auroc


def calculate_accuracy(scores, labels, threshold):
    """Calculate accuracy for a probe on given predictions and labels."""
    labels = labels.detach().cpu().float()
    scores = scores.detach().cpu().float()
    
    preds = scores > threshold

    return balanced_accuracy_score(labels, preds), accuracy_score(labels, preds)
